package com.jpattern.orm.query.clause.where;

import java.util.Collection;
import java.util.List;

import com.jpattern.orm.exception.OrmQueryFormatException;
import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.NullNameSolver;
import com.jpattern.orm.query.SmartRenderableSqlSubElement;

/**
 * 
 * @author Francesco Cina
 *
 * 19/giu/2011
 */
//TODO to refactor!!
public abstract class AExpressionElement extends SmartRenderableSqlSubElement implements ExpressionElement {

	private String property;
	private boolean singleValue;
	private Object value;
	private boolean multipleValues;
	private Collection<?> values;
	private NameSolver nameSolver = new NullNameSolver();


	@Override
	public void setNameSolver(final NameSolver nameSolver) {
		this.nameSolver = nameSolver;
	}

	private PropertyDecorator propertyDecorator = new NullPropertyDecorator();
	private PropertyDecorator valueDecorator = new NullPropertyDecorator();

	public final boolean hasValue() {
		return (this.singleValue);
	}

	public final boolean hasValues() {
		return (this.multipleValues && (this.values!=null) && (this.values.size()>0));
	}

	public Object getValue() {
		return this.value;
	}

	public void setValue(final Object value) {
		this.singleValue = true;
		this.multipleValues = false;
		this.value = value;
	}

	public Collection<?> getValues() {
		return this.values;
	}

	public void setValues(final Collection<?> values) {
		this.singleValue = false;
		this.multipleValues = true;
		this.values = values;
	}

	public final String getProperty() {
		return this.property;
	}

	public void setProperty(final String property) {
		this.property = property;
	}

	protected NameSolver nameSolver() {
		return this.nameSolver;
	}

	protected PropertyDecorator getPropertyDecorator() {
		return this.propertyDecorator;
	}

	protected void setPropertyDecorator(final PropertyDecorator propertyDecorator) {
		this.propertyDecorator = propertyDecorator;
	}

	protected PropertyDecorator getValueDecorator() {
		return this.valueDecorator;
	}

	protected void setValueDecorator(final PropertyDecorator valueDecorator) {
		this.valueDecorator = valueDecorator;
	}

	@Override
	public final void doElementRender(final StringBuilder query) throws OrmQueryFormatException {
		query.append( getPropertyDecorator().decore( nameSolver().solvePropertyName(getProperty()) ) );
		query.append( " " );
		query.append( getExpressionElementKey() );
		query.append( " " );
		appendQuestionMarks(query);
	}

	private void appendQuestionMarks(final StringBuilder query) {
		if (hasValue()) {
			query.append( getValueDecorator().decore("?") + " " );
			return;
		}
		if (hasValues()) {
			query.append( "( ");
			for (int i=0; i<(getValues().size()-1); i++) {
				query.append( getValueDecorator().decore("?") + ", " );
			}
			query.append( getValueDecorator().decore("?") + " ) ");
		}
	}

	@Override
	public final int getElementStatusVersion() {
		return 0;
	}

	public abstract String getExpressionElementKey();


	@Override
	public final void appendElementValues(final List<Object> values) {
		if (hasValue()) {
			values.add(this.value);
		}
		if (hasValues()) {
			values.addAll( this.values );
		}
	}
}
