package com.jpattern.orm.query.clause.order;

import java.util.List;

import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.SmartRenderableSqlSubElement;

/**
 * 
 * @author Francesco Cina
 *
 * 24/giu/2011
 */
public class OrmOrderElement extends SmartRenderableSqlSubElement implements OrderElement {

	private final NameSolver nameSolver;
	private final boolean isFirstElement;
	private final OrderByType type;
	private final String property;

	public OrmOrderElement(final NameSolver nameSolver, final String property, final boolean isFirstElement, final OrderByType type) {
		this.nameSolver = nameSolver;
		this.property = property;
		this.isFirstElement = isFirstElement;
		this.type = type;
	}

	@Override
	public final int getElementStatusVersion() {
		return 0;
	}

	@Override
	public final void doElementRender(final StringBuilder StringBuilder) {
		if (!this.isFirstElement) {
			StringBuilder.append( ", " );
		}
		StringBuilder.append( this.nameSolver.solvePropertyName(this.property) );
		StringBuilder.append( " " );
		StringBuilder.append( this.type.getType() );
		StringBuilder.append( this.type.getNulls() );
	}

	@Override
	public final void appendElementValues(List<Object> values) {
	}

}
