package com.jpattern.orm.query.clause.from;

import com.jpattern.orm.mapper.IOrmClassToolMap;

/**
 * 
 * @author Francesco Cina
 *
 * 27/giu/2011
 */
public class InnerJoinElement extends AFromElement {

	/**
	 * 
	 */

	private final String onLeftProperty;
	private final String onRigthProperty;
	private boolean onClause = true;

	public InnerJoinElement(final IOrmClassToolMap ormClassToolMap, final Class<?> joinClass, final Integer nameSolverClassId) {
		this(ormClassToolMap, joinClass, nameSolverClassId, "", "");
		this.onClause = false;
	}

	public InnerJoinElement(final IOrmClassToolMap ormClassToolMap, final Class<?> joinClass, final Integer nameSolverClassId, final String onLeftProperty, final String onRigthProperty) {
		super(ormClassToolMap, joinClass, nameSolverClassId);
		this.onLeftProperty = onLeftProperty;
		this.onRigthProperty = onRigthProperty;
	}

	@Override
	protected String getJoinName() {
		return "INNER JOIN ";
	}

	@Override
	protected boolean hasOnClause() {
		return this.onClause ;
	}

	@Override
	protected String onLeftProperty() {
		return this.onLeftProperty;
	}

	@Override
	protected String onRightProperty() {
		return this.onRigthProperty;
	}

}
