package com.jpattern.orm.query.clause.from;

import java.util.List;

import com.jpattern.orm.mapper.IOrmClassToolMap;
import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.SmartRenderableSqlSubElement;

/**
 * 
 * @author Francesco Cina
 *
 * 27/giu/2011
 */
public abstract class AFromElement extends SmartRenderableSqlSubElement implements FromElement {

	protected final Class<?> joinClass;
	private NameSolver nameSolver;
	protected final IOrmClassToolMap ormClassToolMap;
	private final Integer nameSolverClassId;

	public AFromElement(final IOrmClassToolMap ormClassToolMap, final Class<?> joinClass, final Integer nameSolverClassId) {
		this.ormClassToolMap = ormClassToolMap;
		this.joinClass = joinClass;
		this.nameSolverClassId = nameSolverClassId;
	}

	@Override
	public void setNameSolver(final NameSolver nameSolver) {
		this.nameSolver = nameSolver;
	}

	@Override
	public final int getElementStatusVersion() {
		return 0;
	}

	@Override
	public final void doElementRender(final StringBuilder stringBuilder) {
		String alias = this.nameSolver.alias(getNameSolverClassId());
		stringBuilder.append( getJoinName() );
		stringBuilder.append(this.ormClassToolMap.getOrmClassTool(this.joinClass).getClassMap().getTableInfo().getTableNameWithSchema() );
		stringBuilder.append( " " );
		stringBuilder.append(alias);

		if (hasOnClause()) {
			stringBuilder.append( " ON " );
			stringBuilder.append( this.nameSolver.solvePropertyName(onLeftProperty()) );
			stringBuilder.append( " = " );
			stringBuilder.append( this.nameSolver.solvePropertyName(onRightProperty()) );
		}

		stringBuilder.append( " " );
	}

	protected abstract String getJoinName();

	protected abstract boolean hasOnClause();

	protected abstract String onLeftProperty();

	protected abstract String onRightProperty();

	public Integer getNameSolverClassId() {
		return this.nameSolverClassId;
	}

	@Override
	public final void appendElementValues(final List<Object> values) {
	}

}