package com.jpattern.orm.query.clause;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.jpattern.orm.query.BaseFindQuery;
import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.NameSolverConsumer;
import com.jpattern.orm.query.NullNameSolver;
import com.jpattern.orm.query.SmartRenderableSqlSubElement;
import com.jpattern.orm.query.clause.where.Expression;
import com.jpattern.orm.query.clause.where.ExpressionElement;

/**
 * 
 * @author Francesco Cina
 *
 * 19/giu/2011
 */
public abstract class OrmWhere<T extends Where<?>> extends SmartRenderableSqlSubElement implements Where<T>, NameSolverConsumer{

	List<ExpressionElement> elementList = new ArrayList<ExpressionElement>();
	private NameSolver nameSolver = new NullNameSolver();

	protected abstract T where();

	@Override
	public T allEq(final Map<String, Object> propertyMap) {
		for (final Entry<String, Object> entry : propertyMap.entrySet()) {
			eq(entry.getKey(), entry.getValue());
		}
		return where();
	}

	@Override
	public T eq(final String property, final Object value) {
		return addExpression( Expression.eq(property, value) );
	}

	@Override
	public T eqProperties(final String firstProperty, final String secondProperty) {
		return addExpression( Expression.eqProperties(firstProperty, secondProperty) );
	}

	@Override
	public T le(final String property, final Object value) {
		return addExpression( Expression.le(property, value) );
	}

	@Override
	public T leProperties(final String firstProperty, final String secondProperty) {
		return addExpression( Expression.leProperties(firstProperty, secondProperty) );
	}

	@Override
	public T ge(final String property, final Object value) {
		return addExpression( Expression.ge(property, value) );
	}

	@Override
	public T geProperties(final String firstProperty, final String secondProperty) {
		return addExpression( Expression.geProperties(firstProperty, secondProperty) );
	}

	@Override
	public T lt(final String property, final Object value) {
		return addExpression( Expression.lt(property, value) );
	}

	@Override
	public T ltProperties(final String firstProperty, final String secondProperty) {
		return addExpression( Expression.ltProperties(firstProperty, secondProperty) );
	}

	@Override
	public T gt(final String property, final Object value) {
		return addExpression( Expression.gt(property, value) );
	}

	@Override
	public T gtProperties(final String firstProperty, final String secondProperty) {
		return addExpression( Expression.gtProperties(firstProperty, secondProperty) );
	}

	@Override
	public T ieq(final String property, final String value) {
		return addExpression(  Expression.ieq(property, value) );
	}

	@Override
	public T ieqProperties(final String firstProperty, final String secondProperty) {
		return addExpression(  Expression.ieqProperties(firstProperty, secondProperty) );
	}

	@Override
	public T ilike(final String property, final String value) {
		return addExpression(  Expression.ilike(property, value) );
	}

	@Override
	public T in(final String property, final Collection<?> values) {
		return addExpression(  Expression.in(property, values) );
	}

	@Override
	public T in(final String property, final Object[] values) {
		return in(property, Arrays.asList( values ));
	}

	@Override
	public T in(final String property, final BaseFindQuery subQuery) {
		return addExpression(  Expression.in(property, subQuery) );
	}

	@Override
	public T nin(final String property, final Collection<?> values) {
		return addExpression(  Expression.nin(property, values) );
	}

	@Override
	public T nin(final String property, final Object[] values) {
		return nin(property, Arrays.asList( values ));
	}

	@Override
	public T nin(final String property, final BaseFindQuery subQuery) {
		return addExpression(  Expression.nin(property, subQuery) );
	}

	@Override
	public T isNotNull(final String property) {
		return addExpression(  Expression.isNotNull(property) );
	}

	@Override
	public T isNull(final String property) {
		return addExpression(  Expression.isNull(property) );
	}

	@Override
	public T like(final String property, final String value) {
		return addExpression(  Expression.like(property, value) );
	}

	@Override
	public T nlike(final String property, final String value) {
		return addExpression(  Expression.nlike(property, value) );
	}

	@Override
	public T ne(final String property, final Object value) {
		return addExpression(  Expression.ne(property, value) );
	}

	@Override
	public T neProperties(final String firstProperty, final String secondProperty) {
		return addExpression(  Expression.neProperties(firstProperty, secondProperty) );
	}

	@Override
	public T not(final ExpressionElement expression) {
		return addExpression(  Expression.not(expression) );
	}

	@Override
	public T or(final ExpressionElement... expressionElements) {
		return or(Arrays.asList(expressionElements));
	}

	@Override
	public T or(final List<ExpressionElement> expressionElements) {
		return addExpression( Expression.or(expressionElements) );
	}

	@Override
	public T and(final ExpressionElement... expressionElements) {
		return and(Arrays.asList(expressionElements));
	}

	@Override
	public T and(final List<ExpressionElement> expressionElements) {
		return addExpression( Expression.and(expressionElements) );
	}

	@Override
	public void setNameSolver(final NameSolver nameSolver) {
		this.nameSolver = nameSolver;
	}

	@Override
	public final void doElementRender(final StringBuilder StringBuilder) {
		boolean first = true;
		if (!this.elementList.isEmpty()) {
			StringBuilder.append("WHERE ");
			for (final ExpressionElement expressionElement : this.elementList) {
				if (!first) {
					StringBuilder.append("AND ");
				}
				expressionElement.renderSqlElement(StringBuilder);
				first = false;
			}
		}
	}

	@Override
	public final void appendElementValues(final List<Object> values) {
		for (final ExpressionElement expressionElement : this.elementList) {
			expressionElement.appendElementValues(values);
		}
	}

	@Override
	public final int getElementStatusVersion() {
		return this.elementList.size();
	}

	private T addExpression(final ExpressionElement expressionElement) {
		expressionElement.setNameSolver(this.nameSolver);
		this.elementList.add(expressionElement);
		return where();
	}

}
