package com.jpattern.orm.query.clause;

import java.util.ArrayList;
import java.util.List;

import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.NameSolverConsumer;
import com.jpattern.orm.query.NullNameSolver;
import com.jpattern.orm.query.SmartRenderableSqlSubElement;
import com.jpattern.orm.query.clause.where.EqExpressionElement;
import com.jpattern.orm.query.clause.where.ExpressionElement;

/**
 * 
 * @author Francesco Cina
 *
 * 10/lug/2011
 */
public abstract class OrmSet<T extends Set<?>> extends SmartRenderableSqlSubElement implements Set<T>, NameSolverConsumer {

	List<ExpressionElement> elementList = new ArrayList<ExpressionElement>();
	private NameSolver nameSolver = new NullNameSolver();

	protected abstract T set();

	@Override
	public T eq(final String property, final Object value) {
		final ExpressionElement expressionElement = new EqExpressionElement(property, value);
		expressionElement.setNameSolver(this.nameSolver);
		this.elementList.add(expressionElement);
		return set();
	}

	@Override
	public final void doElementRender(final StringBuilder stringBuilder) {
		boolean first = true;
		if (!this.elementList.isEmpty()) {
			stringBuilder.append("SET ");
			for (final ExpressionElement expressionElement : this.elementList) {
				if (!first) {
					stringBuilder.append(", ");
				}
				expressionElement.renderSqlElement(stringBuilder);
				first = false;
			}
		}
	}

	@Override
	public final void appendElementValues(final List<Object> values) {
		if (!this.elementList.isEmpty()) {
			for (final ExpressionElement expressionElement : this.elementList) {
				expressionElement.appendElementValues(values);
			}
		}
	}

	@Override
	public void setNameSolver(final NameSolver nameSolver) {
		this.nameSolver = nameSolver;
	}

	@Override
	public final int getElementStatusVersion() {
		return this.elementList.size();
	}
}
