package com.jpattern.orm.query.clause;

import java.util.ArrayList;
import java.util.List;

import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.NameSolverConsumer;
import com.jpattern.orm.query.NullNameSolver;
import com.jpattern.orm.query.SmartRenderableSqlSubElement;
import com.jpattern.orm.query.clause.order.OrderByType;
import com.jpattern.orm.query.clause.order.OrderElement;
import com.jpattern.orm.query.clause.order.OrmOrderElement;

/**
 * 
 * @author Francesco Cina
 *
 * 24/giu/2011
 */
public abstract class OrmOrderBy<T extends OrderBy<?>> extends SmartRenderableSqlSubElement implements OrderBy<T>, NameSolverConsumer {

	private NameSolver nameSolver = new NullNameSolver();
	private final List<OrderElement> elementList = new ArrayList<OrderElement>();

	protected abstract T orderBy();

	@Override
	public final void doElementRender(final StringBuilder stringBuilder) {
		if (!this.elementList.isEmpty()) {
			stringBuilder.append("ORDER BY ");
			for (final OrderElement expressionElement : this.elementList) {
				expressionElement.renderSqlElement(stringBuilder);
			}
		}
	}

	@Override
	public final int getElementStatusVersion() {
		return this.elementList.size();
	}

	@Override
	public void setNameSolver(final NameSolver nameSolver) {
		this.nameSolver  = nameSolver;
	}

	@Override
	public final void appendElementValues(final List<Object> values) {
	}

	@Override
	public T asc(final String property) {
		return addOrderElement(property, OrderByType.ASC);
	}

	@Override
	public T desc(final String property) {
		return addOrderElement(property, OrderByType.DESC);
	}

	@Override
	public T ascNullsFirst(final String property) {
		return addOrderElement(property, OrderByType.ASC_NULLS_FIRST);
	}

	@Override
	public T ascNullsLast(final String property) {
		return addOrderElement(property, OrderByType.ASC_NULLS_LAST);
	}

	@Override
	public T descNullsFirst(final String property) {
		return addOrderElement(property, OrderByType.DESC_NULLS_FIRST);
	}

	@Override
	public T descNullsLast(final String property) {
		return addOrderElement(property, OrderByType.DESC_NULLS_LAST);
	}

	private T addOrderElement(final String property, final OrderByType orderByType) {
		this.elementList.add(new OrmOrderElement(this.nameSolver, property, this.elementList.isEmpty(), orderByType));
		return orderBy();
	}

}
