package com.jpattern.orm.query.clause;

import java.util.ArrayList;
import java.util.List;

import com.jpattern.orm.mapper.IOrmClassToolMap;
import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.NameSolverConsumer;
import com.jpattern.orm.query.NullNameSolver;
import com.jpattern.orm.query.SmartRenderableSqlSubElement;
import com.jpattern.orm.query.clause.from.FromElement;
import com.jpattern.orm.query.clause.from.FullOuterJoinElement;
import com.jpattern.orm.query.clause.from.InnerJoinElement;
import com.jpattern.orm.query.clause.from.JoinElement;
import com.jpattern.orm.query.clause.from.LeftOuterJoinElement;
import com.jpattern.orm.query.clause.from.NaturalJoinElement;
import com.jpattern.orm.query.clause.from.RightOuterJoinElement;

/**
 * 
 * @author Francesco Cina
 *
 * 27/giu/2011
 */
public abstract class OrmFrom<T extends From<?>> extends SmartRenderableSqlSubElement implements From<T>, NameSolverConsumer {

	private NameSolver nameSolver = new NullNameSolver();
	private final List<FromElement> joinElements = new ArrayList<FromElement>();
	private final IOrmClassToolMap ormClassToolMap;
	private final Class<?> clazz;
	private final Integer nameSolverClassId;

	public OrmFrom (final IOrmClassToolMap ormClassToolMap, final Class<?> clazz, final Integer nameSolverClassId) {
		this.ormClassToolMap = ormClassToolMap;
		this.clazz = clazz;
		this.nameSolverClassId = nameSolverClassId;
	}

	protected abstract T from();

	@Override
	public T join(final Class<?> joinClass) {
		return join(joinClass, joinClass.getSimpleName());
	}

	@Override
	public T join(final Class<?> joinClass, final String joinClassAlias) {
		Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
		return addJoinElement( new JoinElement(this.ormClassToolMap, joinClass, nameSolverClassId) );
	}

	@Override
	public T naturalJoin(final Class<?> joinClass) {
		return naturalJoin(joinClass, joinClass.getSimpleName());
	}

	@Override
	public T naturalJoin(final Class<?> joinClass, final String joinClassAlias) {
		Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
		return addJoinElement( new NaturalJoinElement(this.ormClassToolMap, joinClass, nameSolverClassId) );
	}

	@Override
	public T innerJoin(final Class<?> joinClass) {
		return innerJoin(joinClass, joinClass.getSimpleName());
	}

	@Override
	public T innerJoin(final Class<?> joinClass, final String joinClassAlias) {
		Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
		return addJoinElement( new InnerJoinElement(this.ormClassToolMap, joinClass, nameSolverClassId) );
	}

	@Override
	public T innerJoin(final Class<?> joinClass, final String onLeftProperty, final String onRigthProperty) {
		return innerJoin(joinClass, joinClass.getSimpleName(), onLeftProperty, onRigthProperty);
	}

	@Override
	public T innerJoin(final Class<?> joinClass, final String joinClassAlias, final String onLeftProperty, final String onRigthProperty) {
		Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
		return addJoinElement( new InnerJoinElement(this.ormClassToolMap, joinClass, nameSolverClassId, onLeftProperty, onRigthProperty) );
	}

	@Override
	public T leftOuterJoin(final Class<?> joinClass) {
		return leftOuterJoin(joinClass, joinClass.getSimpleName());
	}

	@Override
	public T leftOuterJoin(final Class<?> joinClass, final String joinClassAlias) {
		Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
		return addJoinElement( new LeftOuterJoinElement(this.ormClassToolMap, joinClass, nameSolverClassId) );
	}

	@Override
	public T leftOuterJoin(final Class<?> joinClass, final String onLeftProperty, final String onRigthProperty) {
		return leftOuterJoin(joinClass, joinClass.getSimpleName(), onLeftProperty, onRigthProperty);
	}

	@Override
	public T leftOuterJoin(final Class<?> joinClass, final String joinClassAlias, final String onLeftProperty, final String onRigthProperty) {
		Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
		return addJoinElement( new LeftOuterJoinElement(this.ormClassToolMap, joinClass, nameSolverClassId, onLeftProperty, onRigthProperty) );
	}

	@Override
	public T rightOuterJoin(final Class<?> joinClass) {
		return rightOuterJoin(joinClass, joinClass.getSimpleName());
	}

	@Override
	public T rightOuterJoin(final Class<?> joinClass, final String joinClassAlias) {
		Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
		return addJoinElement( new RightOuterJoinElement(this.ormClassToolMap, joinClass, nameSolverClassId) );
	}

	@Override
	public T rightOuterJoin(final Class<?> joinClass, final String onLeftProperty, final String onRigthProperty) {
		return rightOuterJoin(joinClass, joinClass.getSimpleName(), onLeftProperty, onRigthProperty);
	}

	@Override
	public T rightOuterJoin(final Class<?> joinClass, final String joinClassAlias, final String onLeftProperty, final String onRigthProperty) {
		Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
		return addJoinElement( new RightOuterJoinElement(this.ormClassToolMap, joinClass, nameSolverClassId, onLeftProperty, onRigthProperty) );
	}

	@Override
	public T fullOuterJoin(final Class<?> joinClass) {
		return fullOuterJoin(joinClass, joinClass.getSimpleName());
	}

	@Override
	public T fullOuterJoin(final Class<?> joinClass, final String joinClassAlias) {
		Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
		return addJoinElement( new FullOuterJoinElement(this.ormClassToolMap, joinClass, nameSolverClassId) );
	}

	@Override
	public T fullOuterJoin(final Class<?> joinClass, final String onLeftProperty, final String onRigthProperty) {
		return fullOuterJoin(joinClass, joinClass.getSimpleName(), onLeftProperty, onRigthProperty);
	}

	@Override
	public T fullOuterJoin(final Class<?> joinClass, final String joinClassAlias, final String onLeftProperty, final String onRigthProperty) {
		Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
		return addJoinElement( new FullOuterJoinElement(this.ormClassToolMap, joinClass, nameSolverClassId, onLeftProperty, onRigthProperty) );
	}

	@Override
	public void setNameSolver(final NameSolver nameSolver) {
		this.nameSolver = nameSolver;
	}

	@Override
	public final int getElementStatusVersion() {
		return this.joinElements.size();
	}

	@Override
	public final void doElementRender(final StringBuilder stringBuilder) {
		final String alias = this.nameSolver.alias(this.nameSolverClassId);
		stringBuilder.append("FROM ");
		stringBuilder.append(this.ormClassToolMap.getOrmClassTool(this.clazz).getClassMap().getTableInfo().getTableNameWithSchema() );
		stringBuilder.append( " " );
		stringBuilder.append(alias);
		stringBuilder.append(" ");
		for (final FromElement joinElement : this.joinElements) {
			joinElement.renderSqlElement(stringBuilder);
		}
	}

	@Override
	public final void appendElementValues(final List<Object> values) {
	}

	private T addJoinElement(final FromElement joinElement) {
		joinElement.setNameSolver(this.nameSolver);
		this.joinElements.add(joinElement);
		return from();
	}

}
