package com.jpattern.orm.query;

/**
 * An {@link RenderableSqlSubElement} that keep track of the status of the object.
 * After a call to one of the render methods the result is stored and used for future calls
 * if the status of the object doen't change
 * 
 * @author ufo
 *
 */
public abstract class SmartRenderableSqlSubElement implements RenderableSqlSubElement {

	private int lastStatusVersion = -1;
	private String lastRender = "";

	@Override
	public final String renderSqlElement() {
		final StringBuilder stringBuilder = new StringBuilder();
		renderSqlElement(stringBuilder);
		return stringBuilder.toString();
	}

	@Override
	public final void renderSqlElement(final StringBuilder stringBuilder) {
		int currentStatusVersion = getElementStatusVersion();
		if (currentStatusVersion==this.lastStatusVersion) {
			stringBuilder.append(this.lastRender);
		} else {
			doElementRender(stringBuilder);
		}
	}

	protected abstract void doElementRender(StringBuilder stringBuilder);

	public abstract int getElementStatusVersion();

	public final boolean isElementStatusChanged() {
		return getElementStatusVersion() == this.lastStatusVersion;
	}
}
