package com.jpattern.orm.query;

/**
 * An {@link RenderableSqlSubElement} that keep track of the status of the object.
 * After a call to one of the render methods the result is stored and used for future calls
 * if the status of the object doen't change
 * 
 * @author ufo
 *
 */
public abstract class SmartRenderableSqlQuery implements RenderableSqlQuery {

	private final int lastStatusVersion = -1;
	private final String lastRender = "";

	@Override
	public final String renderSql() {
		final StringBuilder stringBuilder = new StringBuilder();
		renderSql(stringBuilder);
		return stringBuilder.toString();
	}

	@Override
	public final void renderSql(final StringBuilder stringBuilder) {
		int currentStatusVersion = getStatusVersion();
		if (currentStatusVersion==this.lastStatusVersion) {
			stringBuilder.append(this.lastRender);
		} else {
			doRender(stringBuilder);
		}
	}

	protected abstract void doRender(StringBuilder stringBuilder);

	public abstract int getStatusVersion();

	public final boolean isStatusChanged() {
		return getStatusVersion() == this.lastStatusVersion;
	}
}
