package com.jpattern.orm.query;

import java.util.List;

/**
 * 
 * @author Francesco Cina
 *
 * 23/giu/2011
 */
public interface RenderableSqlSubElement  {

	/**
	 * Return the sql query generated by this IQuery Object
	 * @return
	 */
	String renderSqlElement();

	/**
	 * Append to the string buffer the sql query generated by this IQuery Object
	 * @param StringBuilder
	 */
	void renderSqlElement(StringBuilder stringBuilder);

	/**
	 * Append to the list all the values of the expression's elements
	 * @return
	 */
	void appendElementValues(List<Object> values);

}
