package com.jpattern.orm.query;

import java.util.List;

/**
 * 
 * @author Francesco Cina
 *
 * 23/giu/2011
 */
public interface RenderableSqlQuery  {

	/**
	 * Return the sql query generated by this IQuery Object
	 * @return
	 */
	String renderSql();

	/**
	 * Append to the string buffer the sql query generated by this IQuery Object
	 * @param StringBuilder
	 */
	void renderSql(StringBuilder stringBuilder);

	/**
	 * Append to the list all the values of the expression's elements
	 * @return
	 */
	void appendValues(List<Object> values);

}
