package com.jpattern.orm.query;

import com.jpattern.orm.exception.OrmException;

/**
 * 
 * @author Francesco Cina
 *
 * 19/giu/2011
 */
public class NullNameSolver implements NameSolver {

	/**
	 * 
	 */


	@Override
	public String solvePropertyName(final String property) {
		return property;
	}

	@Override
	public <P> Integer register(final Class<P> clazz) {
		return 0;
	}

	@Override
	public <P> Integer register(final Class<P> clazz, final String alias) {
		return 0;
	}

	@Override
	public String alias(final Integer classId) throws OrmException {
		return "";
	}

	@Override
	public String solvePropertyName(final String property, final String defaultValue) throws OrmException {
		return defaultValue;
	}

	@Override
	public String solvePropertyNameWithoutAlias(final String property) throws OrmException {
		return "";
	}

	@Override
	public void alwaysResolveWithoutAlias(final boolean resolveWithoutAlias) {
	}

	@Override
	public boolean getAlwaysResolveWithoutAlias() {
		return false;
	}

}
