package com.jpattern.orm.query;

import com.jpattern.orm.exception.OrmException;

/**
 * 
 * @author Francesco Cina
 *
 * 19/giu/2011
 */
public interface NameSolver  {

	/**
	 * Resolve a property in a query to his name in the database using the table alias as prefix.
	 * @param property
	 * @return
	 */
	String solvePropertyName(String property) throws OrmException;

	/**
	 * Resolve a property in a query to his name in the database using the table alias as prefix.
	 * If the property cannot be solved then the default value is returned.
	 * @param property
	 * @param defaultValue
	 * @return
	 */
	String solvePropertyName(String property, String defaultValue) throws OrmException;

	/**
	 * Resolve a property in a query to his column's related name in the database without using the table alias as prefix.
	 * @param clazz
	 * @param property
	 * @return
	 */
	String solvePropertyNameWithoutAlias(String property) throws OrmException;

	/**
	 * Register a class and use the name of the class as alias to resolve the property name.
	 * @param clazz
	 * @return the registered class id
	 */
	<P> Integer register(Class<P> clazz) throws OrmException;

	/**
	 * Register a class and use the passed alias parameter as alias to resolve the property name.
	 * @param clazz
	 * @param alias
	 * @return the registered class id
	 */
	<P> Integer register(Class<P> clazz, String alias) throws OrmException;

	/**
	 * Return the alias of a registered class
	 * @param clazz
	 * @return
	 * @throws OrmException
	 */
	String alias(Integer clazzId) throws OrmException;

	/**
	 * If set to true always resolves the properties name without prepend the table name alias, even if the solvePropertyName is called
	 * DEFAULT is set to false.
	 * @param resolveWithoutAlias
	 */
	void alwaysResolveWithoutAlias(boolean resolveWithoutAlias);

	/**
	 * Return whether resolve the properties name without prepend the table name alias
	 * @return
	 */
	boolean getAlwaysResolveWithoutAlias();

}
