package com.jpattern.orm.persistor.version;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

import com.jpattern.orm.exception.OrmConfigurationException;
import com.jpattern.orm.util.MapUtil;

/**
 * 
 * @author ufo
 *
 */
public class VersionMathFactory  {

	private Map<Class<?>, VersionMath<?>> maths = new HashMap<Class<?>, VersionMath<?>>();

	public VersionMathFactory() {
		this.addToMap(Integer.TYPE, new IntegerVersionMath());
		this.addToMap(Integer.class, new IntegerVersionMath());
		this.addToMap(Long.TYPE, new LongVersionMath());
		this.addToMap(Long.class, new LongVersionMath());
		this.addToMap(BigDecimal.class, new BigDecimalVersionMath());
	}

	private <K> void addToMap(final Class<K> clazz, final VersionMath<K> math) {
		this.maths.put(clazz, math);
	}

	@SuppressWarnings("unchecked")
	public <T> VersionMath<T> getMath(final Class<T> clazz, final boolean isVersionField) {
		if (!isVersionField) {
			return new NullVersionMath<T>();
		}
		if (this.maths.containsKey(clazz)) {
			return (VersionMath<T>) this.maths.get(clazz);
		}
		throw new OrmConfigurationException("Cannot manipulate version for type [" + clazz + "]. Allowed types [" + MapUtil.keysToString(this.maths) + "].");
	}

}
