package com.jpattern.orm.persistor.version;

import java.lang.reflect.InvocationTargetException;

import com.jpattern.orm.persistor.PropertyPersistor;

/**
 * 
 * @author cinafr
 *
 * @param <BEAN>
 */
public class VersionManipulatorImpl<BEAN> implements VersionManipulator<BEAN> {

	private final PropertyPersistor<BEAN, ?, ?> versionablePersistor;

	public VersionManipulatorImpl(final PropertyPersistor<BEAN, ?, ?> versionablePersistor) {
		this.versionablePersistor = versionablePersistor;
	}

	@Override
	public boolean isVersionable() {
		return true;
	}

	@Override
	public void updateVersion(final BEAN bean, final boolean firstVersionNumber) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
		this.versionablePersistor.increaseVersion(bean, firstVersionNumber);
	}

}
