package com.jpattern.orm.persistor.type.jdbc;

import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class URLJdbcIO implements JdbcIO<URL> {

	@Override
	public URL getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getURL(rsColumnName);
	}

	@Override
	public URL getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getURL(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final URL value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setURL(index, value);
	}

	@Override
	public Class<URL> getDBClass() {
		return URL.class;
	}

}
