package com.jpattern.orm.persistor.type.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class TimestampJdbcIO implements JdbcIO<Timestamp> {

	@Override
	public Timestamp getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getTimestamp(rsColumnName);
	}

	@Override
	public Timestamp getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getTimestamp(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final Timestamp value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setTimestamp(index, value);
	}

	@Override
	public Class<Timestamp> getDBClass() {
		return Timestamp.class;
	}

}
