package com.jpattern.orm.persistor.type.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class TimeJdbcIO implements JdbcIO<Time> {

	@Override
	public Time getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getTime(rsColumnName);
	}

	@Override
	public Time getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getTime(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final Time value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setTime(index, value);
	}

	@Override
	public Class<Time> getDBClass() {
		return Time.class;
	}

}
