package com.jpattern.orm.persistor.type.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class StringJdbcIO implements JdbcIO<String> {

	@Override
	public String getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getString(rsColumnName);
	}

	@Override
	public String getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getString(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final String value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setString(index, value);
	}

	@Override
	public Class<String> getDBClass() {
		return String.class;
	}

}
