package com.jpattern.orm.persistor.type.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class ShortPrimitiveJdbcIO implements JdbcIO<Short> {

	@Override
	public Short getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getShort(rsColumnName);
	}

	@Override
	public Short getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getShort(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final Short value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setShort(index, value);
	}

	@Override
	public Class<Short> getDBClass() {
		return Short.TYPE;
	}

}
