package com.jpattern.orm.persistor.type.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLXML;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class SQLXMLJdbcIO implements JdbcIO<SQLXML> {

	@Override
	public SQLXML getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getSQLXML(rsColumnName);
	}

	@Override
	public SQLXML getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getSQLXML(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final SQLXML value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setSQLXML(index, value);
	}

	@Override
	public Class<SQLXML> getDBClass() {
		return SQLXML.class;
	}
}
