package com.jpattern.orm.persistor.type.jdbc;

import java.sql.PreparedStatement;
import java.sql.RowId;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class RowIdJdbcIO implements JdbcIO<RowId> {

	@Override
	public RowId getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getRowId(rsColumnName);
	}

	@Override
	public RowId getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getRowId(rsColumnIndex);
	}
	
	@Override
	public void setValueToPreparedStatement(final RowId value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setRowId(index, value);
	}

	@Override
	public Class<RowId> getDBClass() {
		return RowId.class;
	}

}
