package com.jpattern.orm.persistor.type.jdbc;

import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class RefJdbcIO implements JdbcIO<Ref> {

	@Override
	public Ref getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getRef(rsColumnName);
	}

	@Override
	public Ref getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getRef(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final Ref value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setRef(index, value);
	}

	@Override
	public Class<Ref> getDBClass() {
		return Ref.class;
	}

}
