package com.jpattern.orm.persistor.type.jdbc;

import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class ReaderJdbcIO implements JdbcIO<Reader> {

	@Override
	public Reader getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getCharacterStream(rsColumnName);
	}

	@Override
	public Reader getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getCharacterStream(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final Reader value, final PreparedStatement ps,
			final int index) throws SQLException {
		if (value!=null) {
			ps.setCharacterStream(index, value);
		} else {
			ps.setObject(index, value);
		}
	}

	@Override
	public Class<Reader> getDBClass() {
		return Reader.class;
	}

}
