package com.jpattern.orm.persistor.type.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class ObjectJdbcIO implements JdbcIO<Object> {

	@Override
	public Object getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getObject(rsColumnName);
	}

	@Override
	public Object getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getObject(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final Object value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setObject(index, value);
	}

	@Override
	public Class<Object> getDBClass() {
		return Object.class;
	}

}
