package com.jpattern.orm.persistor.type.jdbc;

import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class NClobJdbcIO implements JdbcIO<NClob> {

	@Override
	public NClob getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getNClob(rsColumnName);
	}

	@Override
	public NClob getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getNClob(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final NClob value, final PreparedStatement ps,
			final int index) throws SQLException {
		if (value!=null) {
			ps.setNClob(index, value);
		} else {
			ps.setObject(index, value);
		}
	}

	@Override
	public Class<NClob> getDBClass() {
		return NClob.class;
	}

}
