package com.jpattern.orm.persistor.type.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class LongPrimitiveJdbcIO implements JdbcIO<Long> {

	@Override
	public Long getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getLong(rsColumnName);
	}

	@Override
	public Long getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getLong(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final Long value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setLong(index, value);
	}

	@Override
	public Class<Long> getDBClass() {
		return Long.TYPE;
	}

}
