package com.jpattern.orm.persistor.type.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class IntegerPrimitiveJdbcIO implements JdbcIO<Integer> {

	@Override
	public Integer getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getInt(rsColumnName);
	}

	@Override
	public Integer getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getInt(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final Integer value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setInt(index, value);
	}

	@Override
	public Class<Integer> getDBClass() {
		return Integer.TYPE;
	}

}
