package com.jpattern.orm.persistor.type.jdbc;

import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class InputStreamJdbcIO implements JdbcIO<InputStream> {

	@Override
	public InputStream getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getBinaryStream(rsColumnName);
	}

	@Override
	public InputStream getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getBinaryStream(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final InputStream value, final PreparedStatement ps,
			final int index) throws SQLException {
		if (value!=null) {
			ps.setBinaryStream(index, value);
		} else {
			ps.setObject(index, value);
		}
	}

	@Override
	public Class<InputStream> getDBClass() {
		return InputStream.class;
	}

}
