package com.jpattern.orm.persistor.type.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class FloatPrimitiveJdbcIO implements JdbcIO<Float> {

	@Override
	public Float getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getFloat(rsColumnName);
	}

	@Override
	public Float getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getFloat(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final Float value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setFloat(index, value);
	}

	@Override
	public Class<Float> getDBClass() {
		return Float.TYPE;
	}

}
