package com.jpattern.orm.persistor.type.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class DoublePrimitiveJdbcIO implements JdbcIO<Double> {

	@Override
	public Double getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getDouble(rsColumnName);
	}

	@Override
	public Double getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getDouble(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final Double value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setDouble(index, value);
	}

	@Override
	public Class<Double> getDBClass() {
		return Double.TYPE;
	}

}
