package com.jpattern.orm.persistor.type.jdbc;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class DateJdbcIO implements JdbcIO<Date> {

	@Override
	public Date getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getDate(rsColumnName);
	}

	@Override
	public Date getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getDate(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final Date value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setDate(index, value);
	}

	@Override
	public Class<Date> getDBClass() {
		return Date.class;
	}

}
