package com.jpattern.orm.persistor.type.jdbc;

import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class ClobJdbcIO implements JdbcIO<Clob> {

	@Override
	public Clob getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getClob(rsColumnName);
	}

	@Override
	public Clob getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getClob(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final Clob value, final PreparedStatement ps,
			final int index) throws SQLException {
		if (value!=null) {
			ps.setClob(index, value);
		} else {
			ps.setObject(index, value);
		}
	}

	@Override
	public Class<Clob> getDBClass() {
		return Clob.class;
	}

}
