package com.jpattern.orm.persistor.type.jdbc;

import com.jpattern.orm.persistor.type.TypeWrapper;


public class BytesNullWrapper implements TypeWrapper<byte[], byte[]> {

	@Override
	public Class<byte[]> jdbcType() {
		return byte[].class;
	}

	@Override
	public Class<byte[]> propertyType() {
		return byte[].class;
	}

	@Override
	public byte[] wrap(final byte[] value) {
		return value;
	}

	@Override
	public byte[] unWrap(final byte[] value) {
		return value;
	}

	@Override
	public byte[] clone(final byte[] source) {
		if(source!=null) {
			return source.clone();
		}
		return null;
	}

}
