package com.jpattern.orm.persistor.type.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class BytesJdbcIO implements JdbcIO<byte[]> {

	@Override
	public byte[] getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getBytes(rsColumnName);
	}

	@Override
	public byte[] getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getBytes(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final byte[] value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setBytes(index, value);
	}

	@Override
	public Class<byte[]> getDBClass() {
		return byte[].class;
	}

}
