package com.jpattern.orm.persistor.type.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class BytePrimitiveJdbcIO implements JdbcIO<Byte> {

	@Override
	public Byte getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getByte(rsColumnName);
	}

	@Override
	public Byte getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getByte(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final Byte value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setByte(index, value);
	}

	@Override
	public Class<Byte> getDBClass() {
		return Byte.TYPE;
	}

}
