package com.jpattern.orm.persistor.type.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class BooleanPrimitiveJdbcIO implements JdbcIO<Boolean> {

	@Override
	public Boolean getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getBoolean(rsColumnName);
	}

	@Override
	public Boolean getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getBoolean(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final Boolean value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setBoolean(index, value);
	}

	@Override
	public Class<Boolean> getDBClass() {
		return Boolean.TYPE;
	}

}
