package com.jpattern.orm.persistor.type.jdbc;

import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class BlobJdbcIO implements JdbcIO<Blob> {

	@Override
	public Blob getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getBlob(rsColumnName);
	}

	@Override
	public Blob getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getBlob(rsColumnIndex);
	}
	
	@Override
	public void setValueToPreparedStatement(final Blob value, final PreparedStatement ps,
			final int index) throws SQLException {
		if (value!=null) {
			ps.setBlob(index, value);
		} else {
			ps.setObject(index, value);
		}
	}

	@Override
	public Class<Blob> getDBClass() {
		return Blob.class;
	}
	

}
