package com.jpattern.orm.persistor.type.jdbc;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class BigDecimalJdbcIO implements JdbcIO<BigDecimal> {

	@Override
	public BigDecimal getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getBigDecimal(rsColumnName);
	}

	@Override
	public BigDecimal getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getBigDecimal(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final BigDecimal value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setBigDecimal(index, value);
	}

	@Override
	public Class<BigDecimal> getDBClass() {
		return BigDecimal.class;
	}

}
