package com.jpattern.orm.persistor.type.jdbc;

import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.persistor.type.JdbcIO;

/**
 * 
 * @author ufo
 *
 */
public class ArrayJdbcIO implements JdbcIO<Array> {

	@Override
	public Array getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException {
		return rs.getArray(rsColumnName);
	}

	@Override
	public Array getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException {
		return rs.getArray(rsColumnIndex);
	}

	@Override
	public void setValueToPreparedStatement(final Array value, final PreparedStatement ps,
			final int index) throws SQLException {
		ps.setArray(index, value);
	}

	@Override
	public Class<Array> getDBClass() {
		return Array.class;
	}

}
