package com.jpattern.orm.persistor.type.ext;

import com.jpattern.orm.persistor.type.TypeFactory;
import com.jpattern.orm.persistor.type.TypeWrapper;

/**
 * 
 * @author Francesco Cina'
 *
 * Apr 17, 2012
 */
public class WrapperTypeArray {

	private final TypeFactory typeFactory;

	public WrapperTypeArray(final TypeFactory typeFactory) {
		this.typeFactory = typeFactory;
	}

	/**
	 * Take an array of Objects and return and for each Object's class check if a
	 * WrapperType exists. If the wrapper exists the object will be unwrapped otherwise
	 * it will be left as is.
	 * The output is a new array with the same size that contains, in the same position, the
	 * original value or his unwrapped counterpart
	 * @param array
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public Object[] unWrap(final Object[] array) {
		final Object[] result = new Object[array.length];
		for (int i=0; i<array.length ; i++) {
			final Object obj = array[i];

			if (obj!=null) {
				result[i] = ( (TypeWrapper<Object, Object>) this.typeFactory.getTypeWrapper(obj.getClass())).unWrap(obj);
			} else {
				result[i] = obj;
			}
		}
		return result;
	}

}
