package com.jpattern.orm.persistor.type.ext;

import java.sql.Timestamp;
import java.util.Date;

import com.jpattern.orm.persistor.type.ExtendedTypeWrapper;

/**
 * 
 * @author Francesco Cina'
 *
 * Mar 27, 2012
 */
public class UtilDateToSqlTimestampWrapper implements ExtendedTypeWrapper<Date, Timestamp> {

	@Override
	public Class<Timestamp> jdbcType() {
		return Timestamp.class;
	}

	@Override
	public Class<Date> propertyType() {
		return Date.class;
	}

	@Override
	public Date wrap(final Timestamp value) {
		return value;
	}

	@Override
	public Timestamp unWrap(final Date value) {
		if (value==null) {
			return null;
		}
		return new Timestamp(value.getTime());
	}

	@Override
	public Date clone(final Date source) {
		return source;
	}

}
