package com.jpattern.orm.persistor.type.ext;

import java.math.BigDecimal;

import com.jpattern.orm.persistor.type.ExtendedTypeWrapper;

/**
 * 
 * @author Francesco Cina'
 *
 * Apr 1, 2012
 */
public class ShortToBigDecimalWrapper implements ExtendedTypeWrapper<Short, BigDecimal> {

	@Override
	public Class<BigDecimal> jdbcType() {
		return BigDecimal.class;
	}

	@Override
	public Class<Short> propertyType() {
		return Short.class;
	}

	@Override
	public Short wrap(final BigDecimal value) {
		if (value==null) {
			return null;
		}
		return value.shortValue();
	}

	@Override
	public BigDecimal unWrap(final Short value) {
		if (value==null) {
			return null;
		}
		return BigDecimal.valueOf(value);
	}

	@Override
	public Short clone(final Short source) {
		return source;
	}

}
