package com.jpattern.orm.persistor.type.ext;

import java.math.BigDecimal;

import com.jpattern.orm.persistor.type.ExtendedTypeWrapper;

/**
 * 
 * @author Francesco Cina'
 *
 * Apr 1, 2012
 */
public class LongToBigDecimalWrapper implements ExtendedTypeWrapper<Long, BigDecimal> {

	@Override
	public Class<BigDecimal> jdbcType() {
		return BigDecimal.class;
	}

	@Override
	public Class<Long> propertyType() {
		return Long.class;
	}

	@Override
	public Long wrap(final BigDecimal value) {
		if (value==null) {
			return null;
		}
		return value.longValue();
	}

	@Override
	public BigDecimal unWrap(final Long value) {
		if (value==null) {
			return null;
		}
		return BigDecimal.valueOf(value);
	}

	@Override
	public Long clone(final Long source) {
		return source;
	}

}
