package com.jpattern.orm.persistor.type.ext;

import java.sql.Timestamp;

import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

import com.jpattern.orm.persistor.type.ExtendedTypeWrapper;

/**
 * 
 * @author Francesco Cina'
 *
 * Mar 27, 2012
 */
public class JodaLocalDateToSqlTimestampWrapper implements ExtendedTypeWrapper<LocalDate, Timestamp> {

	@Override
	public Class<Timestamp> jdbcType() {
		return Timestamp.class;
	}

	@Override
	public Class<LocalDate> propertyType() {
		return LocalDate.class;
	}

	@Override
	public LocalDate wrap(final Timestamp value) {
		if (value==null) {
			return null;
		}
		return new LocalDate(value, DateTimeZone.UTC);
	}

	@Override
	public Timestamp unWrap(final LocalDate value) {
		if (value==null) {
			return null;
		}
		return new Timestamp(value.toDateMidnight().getMillis());
	}

	@Override
	public LocalDate clone(final LocalDate source) {
		return source;
	}

}
