package com.jpattern.orm.persistor.type.ext;

import java.sql.Timestamp;

import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

import com.jpattern.orm.persistor.type.ExtendedTypeWrapper;

/**
 * 
 * @author Francesco Cina'
 *
 * Mar 27, 2012
 */
public class JodaLocalDateTimeToSqlTimestampWrapper implements ExtendedTypeWrapper<LocalDateTime, Timestamp> {

	@Override
	public Class<Timestamp> jdbcType() {
		return Timestamp.class;
	}

	@Override
	public Class<LocalDateTime> propertyType() {
		return LocalDateTime.class;
	}

	@Override
	public LocalDateTime wrap(final Timestamp value) {
		if (value==null) {
			return null;
		}
		return new LocalDateTime(value, DateTimeZone.UTC);
	}

	@Override
	public Timestamp unWrap(final LocalDateTime value) {
		if (value==null) {
			return null;
		}
		return new Timestamp(value.toDateTime().getMillis());
	}

	@Override
	public LocalDateTime clone(final LocalDateTime source) {
		return source;
	}

}
