package com.jpattern.orm.persistor.type.ext;

import java.sql.Timestamp;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

import com.jpattern.orm.persistor.type.ExtendedTypeWrapper;

/**
 * 
 * @author Francesco Cina'
 *
 * Mar 27, 2012
 */
public class JodaDateTimeToSqlTimestampWrapper implements ExtendedTypeWrapper<DateTime, Timestamp> {

	@Override
	public Class<Timestamp> jdbcType() {
		return Timestamp.class;
	}

	@Override
	public Class<DateTime> propertyType() {
		return DateTime.class;
	}

	@Override
	public DateTime wrap(final Timestamp value) {
		if (value==null) {
			return null;
		}
		return new DateTime(value, DateTimeZone.UTC);
	}

	@Override
	public Timestamp unWrap(final DateTime value) {
		if (value==null) {
			return null;
		}
		return new Timestamp(value.getMillis());
	}

	@Override
	public DateTime clone(final DateTime source) {
		return source;
	}

}
