package com.jpattern.orm.persistor.type.ext;

import java.sql.Timestamp;

import org.joda.time.DateMidnight;
import org.joda.time.DateTimeZone;

import com.jpattern.orm.persistor.type.ExtendedTypeWrapper;

/**
 * 
 * @author Francesco Cina'
 *
 * Mar 27, 2012
 */
public class JodaDateMidnightToTimestampWrapper implements ExtendedTypeWrapper<DateMidnight, Timestamp> {

	@Override
	public Class<Timestamp> jdbcType() {
		return Timestamp.class;
	}

	@Override
	public Class<DateMidnight> propertyType() {
		return DateMidnight.class;
	}

	@Override
	public DateMidnight wrap(final Timestamp value) {
		if (value==null) {
			return null;
		}
		return new DateMidnight(value.getTime(), DateTimeZone.UTC);
	}

	@Override
	public Timestamp unWrap(final DateMidnight value) {
		if (value==null) {
			return null;
		}
		return new Timestamp(value.getMillis());
	}

	@Override
	public DateMidnight clone(final DateMidnight source) {
		return source;
	}

}
