package com.jpattern.orm.persistor.type.ext;

import java.math.BigDecimal;

import com.jpattern.orm.persistor.type.ExtendedTypeWrapper;

/**
 * 
 * @author Francesco Cina'
 *
 * Apr 1, 2012
 */
public class IntegerToBigDecimalWrapper implements ExtendedTypeWrapper<Integer, BigDecimal> {

	@Override
	public Class<BigDecimal> jdbcType() {
		return BigDecimal.class;
	}

	@Override
	public Class<Integer> propertyType() {
		return Integer.class;
	}

	@Override
	public Integer wrap(final BigDecimal value) {
		if (value==null) {
			return null;
		}
		return value.intValue();
	}

	@Override
	public BigDecimal unWrap(final Integer value) {
		if (value==null) {
			return null;
		}
		return BigDecimal.valueOf(value);
	}

	@Override
	public Integer clone(final Integer source) {
		return source;
	}

}
